﻿#$baseURL = "https://192.168.2.136:4450/admin"
#$baseURL = "https://192.168.100.165:4450/admin"
$baseURL = "https://10.91.160.135:4450/admin"
$AdminUser = "admin"
$password = "alaska"

# Only to ignore certificates errors
add-type @"
    using System.Net;
    using System.Security.Cryptography.X509Certificates;

        public class IDontCarePolicy : ICertificatePolicy {
        public IDontCarePolicy() {}
        public bool CheckValidationResult(
            ServicePoint sPoint, X509Certificate cert,
            WebRequest wRequest, int certProb) {
            return true;
        }
    }
"@
[System.Net.ServicePointManager]::CertificatePolicy = new-object IDontCarePolicy 
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12


# authentication
$authBody = "{""userName"": ""$AdminUser"", ""password"": ""$password"", ""authType"": ""EFT""}"
$auth = Invoke-RestMethod -Uri "$baseURL/v1/authentication" -Method 'POST' -Body $authBody

$authToken = $auth.authToken
$authHeader = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$authHeader.Add("Authorization", "EFTAdminAuthToken $authToken")


# get sites
Write-Output "Site"
Write-Output "----"
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json
foreach ($site in $siteList.data)
{
    Write-Output ("Site  $($site.id): $($site.attributes.name)")
}

$siteID = $siteList.data[0].id

###
#Get Site User Settings Template
Write-Output "Get Site User Settings Template"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
##


###
#POST Site User Settings Template (Create)
#POST new site Custom Command
Write-Output "POST User Settings Template (New User Settings Template)"
Write-Output "-----"
$update = 
'{
    "data":{
        "type": "userTemplate",
        "attributes":{
            "name": "GSB Template 4",
            "accountEnabled": true,
            "homeFolder": {
                "enabled": false,
                "value": {
                    "path": ""
                }
            }
        },
        "passwordComplexity": {
          "enabled": "inherit",
          "value": {
            "minLength": 8,
            "characterCategories": {
              "enabled": true,
              "value": {
                "characterCount": 4,
                "upperCaseRequired": true,
                "lowerCaseRequired": true,
                "numericRequired": true,
                "nonAlphaNumericRequired": false,
                "non7bitAsciiRequired": false
              }
            },
            "usernameCharLimit": {
              "enabled": true,
              "value": {
                "minDisallowed": 3
              }
            }
          }
        },
        "sftp": {
          "enabled": true,
          "value": {
            "authenticationType": "password"
          }
        },
        "ssl": {
          "authenticationType": "password"
        }
      }
    
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates" -Method 'POST' -Headers $authHeader -Body $update


########################################
#GET Specific User Settings Template

###
#Get Specific User Settings Templates
Write-Output "Get Specific User Settings Template"
Write-Output "-----"
$userTemplates = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($userTemplates in $userTemplates.id)
{
    Write-Output ("User Template found:  $($userTemplates.id): $($userTemplates.attributes.name)")
}
$userTemplateID = $userTemplates.data[3].id

###
#Get Specific User Template
Write-Output "Get User Template for: "  $userTemplateID " with name: " $userTemplate.data.attributes.name
Write-Output "-----"
$userTemplate = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates/$userTemplateID" -Method 'GET' -Headers $authHeader
Write-Output $userTemplate | ConvertTo-Json -Depth 10

##################################################################################

#####################################################
##PATCH (Update) specific User Settings Template
###
#Get Specific User Settings Templates
Write-Output "Get Specific User Settings Template"
Write-Output "-----"
$userTemplates = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($userTemplates in $userTemplates.id)
{
    Write-Output ("User Template found:  $($userTemplates.id): $($userTemplates.attributes.name)")
}
$userTemplateID = $userTemplates.data[3].id

###
#Get Specific User Template
Write-Output "Get User Template for: "  $userTemplateID " with name: " $userTemplate.data.attributes.name
Write-Output "-----"
$userTemplate = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates/$userTemplateID" -Method 'GET' -Headers $authHeader
Write-Output $userTemplate | ConvertTo-Json -Depth 10


###
##Patch Specific User Settings Template
Write-Output "User Settings Template Patch (update)"
Write-Output "-----"
$update = 
'{
    "data":{
        "type": "userTemplate",
          "attributes": {
            "enabled": false,
            "homeFolder": {
                "enabled": true,
                "value": {
                    "path": ""
                }
            }
        }
    }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates/$userTemplateID" -Method 'PATCH' -Headers $authHeader -Body $update


##########################################################
#Delete User Settings Template

#Get Specific User Settings Templates
Write-Output "Get Specific User Settings Template"
Write-Output "-----"
$userTemplates = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($userTemplates in $userTemplates.id)
{
    Write-Output ("User Template found:  $($userTemplates.id): $($userTemplates.attributes.name)")
}
$userTemplateID = $userTemplates.data[3].id

###
#Get Specific User Template
Write-Output "Get User Template for: "  $userTemplateID " with name: " $userTemplate.data.attributes.name
Write-Output "-----"
$userTemplate = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates/$userTemplateID" -Method 'GET' -Headers $authHeader
Write-Output $userTemplate | ConvertTo-Json -Depth 10

#Delete Request
Write-Output "Deleting User Settings Template: "  $userTemplateID
Write-Output "-----"
$commandList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/user-templates/$userTemplateID" -Method 'DELETE' -Headers $authHeader
Write-Output $commandList | ConvertTo-Json -Depth 10